SUBROUTINE qmapping_spline(gefsv12_quantiles_on_ndfd, &
	precip_gefsv12_on_ndfd, spline_info_inv, &
	fraction_zero_ndfd, usegamma, use99, offset, &
	ny_ndfd, nx_ndfd, qmapped_precip)
	
! sudo f2py --opt='-O4' --opt='-Wno-tabs' -c -m qmapping_spline qmapping_spline.f90 cumgam.f90 gamma_inc.f90 error_f.f90 error_fc.f90 exparg.f90 gam1.f90 ipmpar.f90 pgamma.f90 dgamma.f90 qgamma.f90 rlog.f90 rexp.f90 dnorm.f90 pnorm.f90 qnorm.f90 gamma.f90 splev.f fpbspl.f
	
INTEGER, INTENT(IN) ::  ny_ndfd, nx_ndfd
REAL*8, INTENT(IN), DIMENSION(ny_ndfd, nx_ndfd) :: &
	gefsv12_quantiles_on_ndfd, precip_gefsv12_on_ndfd, &
	fraction_zero_ndfd, offset
INTEGER, INTENT(IN), DIMENSION(ny_ndfd, nx_ndfd) :: usegamma
REAL*8, INTENT(IN), DIMENSION(ny_ndfd, nx_ndfd,2,17) :: spline_info_inv
LOGICAL, INTENT(IN) :: use99
REAL*8, INTENT(OUT), DIMENSION(ny_ndfd, nx_ndfd) ::	qmapped_precip

! f2py intent(in) ny_ndfd, nx_ndfd
! f2py intent(in) gefsv12_quantiles_on_ndfd, precip_gefsv12_on_ndfd
! f2py intent(in) fraction_zero_ndfd, usegamma, offset, use99
! f2py intent(out) qmapped_precip
! f2py depend(ny_ndfd, nx_ndfd) gefsv12_quantiles_on_ndfd, precip_gefsv12_on_ndfd
! f2py depend(ny_ndfd, nx_ndfd) fraction_zero_ndfd, qmapped_precip, usegamma, offset
! f2py depend(ny_ndfd, nx_ndfd,2,17) spline_info_inv

REAL*8 alpha, beta, scale, cum, qgamma
REAL knots(17), bspline_coef(17), qmp, hazard_fn(1), qpositive

LOGICAL tootrue, toofalse

tootrue = .true.
toofalse = .false.

DO jy = 1, ny_ndfd
	DO ix = 1, nx_ndfd

		!IF (jy .eq. 810 .and. ix .eq. 924) PRINT *, &
		!	'precip_gefsv12_on_ndfd(810,924) = ', precip_gefsv12_on_ndfd(810,924)
		IF (precip_gefsv12_on_ndfd(jy,ix) .eq. 0.0) THEN

			! ---- arbitrarily assign the CDF to zero if precip is zero.
        
			qmapped_precip(jy,ix) = 0.0
			 
		ELSE IF (gefsv12_quantiles_on_ndfd(jy,ix) .lt. fraction_zero_ndfd(jy,ix)) THEN

			qmapped_precip(jy,ix)  = 0.0
			
		ELSE
			
			! ---- offset being greater than zero is an indication to assume the quantile
			!      is the 99th percentile. 
			
			IF (offset(jy,ix) .gt. 0.0) THEN
				qpositive = (0.99 - fraction_zero_ndfd(jy,ix))/  &
		            (1.0 - fraction_zero_ndfd(jy,ix))
			ELSE	
				qpositive = (gefsv12_quantiles_on_ndfd(jy,ix) - fraction_zero_ndfd(jy,ix))/  &
		            (1.0 - fraction_zero_ndfd(jy,ix))
			END IF
			
		    IF (usegamma(jy,ix) .eq. 1) THEN 

		    	! ---- this was flagged as a dry point that estimated CDF with a Gamma.

		        alpha = spline_info_inv(jy,ix,1,1)   ! previously stored here
		        beta = spline_info_inv(jy,ix,2,1)    ! previously stored here
		        scale = 1.0 / beta
				cum = gefsv12_quantiles_on_ndfd(jy,ix)
				qmp = qgamma(cum,alpha,beta,tootrue,toofalse)
				
				! --- with lack of training data, let's constrain the amount of quantile
				!     mapping possible
				
				IF (qmp/precip_gefsv12_on_ndfd(jy,ix) .gt. 2.0) &
					qmp = precip_gefsv12_on_ndfd(jy,ix)*2.0
					
			ELSE
                
				IF (spline_info_inv(jy,ix,1,1) .eq. -99.99) THEN ! flag for no + training data
					
					qmp = precip_gefsv12_on_ndfd(jy,ix)

				ELSE
					
					! ---- flagged as a wet-enough point to estimate the CDF with 
					!      the spline fit to a hazard function. 
            
					knots(:) = spline_info_inv(jy,ix,1,:)
					bspline_coef(:) = spline_info_inv(jy,ix,2,:)
					hazard_fn(1) = -log(1.0 - qpositive) 
					CALL splev(knots, 17, bspline_coef, 3, hazard_fn, qmp, 1,ier)
					
				ENDIF
			ENDIF
			
			qmapped_precip(jy,ix) = qmp
			
		END IF
		
		
		IF (use99 .eqv. .TRUE. .and. offset(jy,ix) .gt. 0.0) THEN
			qmapped_precip(jy,ix) = qmapped_precip(jy,ix) + offset(jy,ix)
		ENDIF
		
		
		IF (jy .eq. 800 .and. ix .eq. 970) THEN
			PRINT *,'   800,970: usegamma, qmp, offset, qmapped = ', &
				usegamma(jy,ix), qmp, offset(jy,ix), qmapped_precip(jy,ix) 
			PRINT *,'   qpositive, fraction_zero_ndfd(jy,ix) ', &
				qpositive, fraction_zero_ndfd(jy,ix)
			PRINT *,'   hazard_fn(1) = ', 	hazard_fn(1)
			PRINT *,'   bspline_coef(:) = ', bspline_coef(:)
			PRINT *,'   knots(:) = ', knots(:)
		ENDIF
				
	END DO ! ix
END DO ! jy

RETURN
END SUBROUTINE qmapping_spline
