#!/bin/bash


#get lidar data from internal computer using ftp
# do not exit program even if error occurs
set +e

#network connection
host="192.168.1.203"
#direct connection
#host="192.168.0.101"
user="end user"
passwd="halo"

#for testing
#rawassistdir='/mnt/c/Data/AssistII'
#rawassistdir='/mnt/c/Data/ASSISTII/SUMMARY/'
#pdate='20230809'

pwd=$PWD
echo $PWD
echo $pdate

pdate2=${pdate:0:4}-${pdate:4:2}-${pdate:6:2}
year=${pdate:0:4}
yearmonth=${pdate:0:6}

echo $pdate2

#yesterday
yesterday=$(date --date yesterday "+%Y%m%d")
yearyesterday=${yesterday:0:4}
yearmonthyesterday=${yesterday:0:6}

#download all files from $pdate
echo 'sync data from internal computer using pscp'
cd $rawlidardir/$pdate
echo $rawlidardir
/mnt/c/Program\ Files/PuTTY/pscp.exe -pw $passwd "end user"@$host:C:/Lidar/Data/Proc/$year/$yearmonth/$pdate/* .
echo 'finished sync for '$pdate


##download all files from $yesterday if shortly after midnight to make sure that everything is copied
#
currenttime=$(date +%H:%M)
echo "current time is " $currenttime
if [[ "$currenttime" < "00:10" ]] ; then
echo 'sync data from yesterday '$yesterday
cd $rawlidardir/$yesterday
/mnt/c/Program\ Files/PuTTY/pscp.exe $user@$host:C:/Lidar/Data/Proc/$yearyesterday/$yearmonthyesterday/$yesterday/* .

fi



cd $pwd
#ftp -inv $host << EOF
#user $user $passwd



