import os
import glob
import xarray as xr


windoedir = os.getenv('windoedir')
combination = os.getenv('combination')
version = os.getenv('oversion')
pdate = os.getenv('pdate')

fin = glob.glob(os.path.join(windoedir,'retrieval_output',combination+'*'+version+'*'+pdate+'*.nc'))

if len(fin) == 0:
    print('no retrieval file found')
else:
    print('read '+fin[0])
    IN = xr.open_dataset(fin[0],decode_times=False,drop_variables='dfs')
    OUT = IN.drop_dims(['obs_dim','arb_dim1','nht2'])
    fout = os.path.join(windoedir,'retrieval_output_small',os.path.basename(fin[0]))
    print('write '+fout)
    OUT.to_netcdf(fout)
